﻿#using System.IO;
#using System.Threading.Tasks; 

#using Tessa.Cards;
#using Tessa.Cards.Numbers;

const string bAgreedAlias = "Agreed";
const string bRebuildAlias = "Rebuild";

const string justificationAlias = "ExJustification";
const string verificationResultAlias = "VerificationResult";

const string mCardFileCategoryName = "Финансовое обоснование";
const string fileIDContentSourcesAlias = "FileIDContentSources";

if(string.Equals(Dialog.ButtonName, bAgreedAlias, StringComparison.Ordinal)
	|| string.Equals(Dialog.ButtonName, bRebuildAlias, StringComparison.Ordinal))
{
	var mCard = await this.GetCardObjectAsync();

	if (mCard is null)
	{
		return;
	}

	var dCard = await Dialog.GetDialogCardAsync(this.CancellationToken);

	if (dCard is null)
	{
		return;
	}

	mCard.Sections[justificationAlias].Fields[verificationResultAlias] = dCard.Sections[justificationAlias].RawFields[verificationResultAlias];

	var dCardFiles = dCard.TryGetFiles();

	// В карточке диалога нет файлов?
	if (dCardFiles?.Any() != true)
	{
		return;
	}

	Dictionary<Guid, Guid> fileIDContentSources;
	
	if(this.WorkflowProcess.InfoStorage.TryGetValue(fileIDContentSourcesAlias, out var fileIDContentSourcesObj)
		&& fileIDContentSourcesObj is Dictionary<string, object> fileIDContentSourcesObjDict)
	{
		fileIDContentSources = fileIDContentSourcesObjDict.ToDictionary(i => Guid.ParseExact(i.Key, "N"), j => Guid.ParseExact((string) j.Value, "N"));
	}
	else
	{
		fileIDContentSources = null;
	}

	Guid? GetFileIDContentSource(Guid fileRowID)
	{
		if(fileIDContentSources is not null
			&& fileIDContentSources.TryGetValue(fileRowID, out var fileIDContentSource))
		{
			return fileIDContentSource;
		}
		return default;
	}

	var mCardFileContainer = (await this.KrScope.GetMainCardFileContainerAsync(this.CardID, cancellationToken: this.CancellationToken)).FileContainer;
	var mFiles = mCardFileContainer.Files;

	// Удаление файлов из основной карточки, удалённых из карточки диалога.
	var deletedFileIDCollection = mFiles
		.Where(mFile => string.Equals(mFile.Category?.Caption, mCardFileCategoryName, StringComparison.Ordinal))
		.Select(mFile => mFile.ID)
		.Except(dCardFiles
			.Select(dCardFile => GetFileIDContentSource(dCardFile.RowID))
			.Where(mFileID => mFileID.HasValue)
			.Cast<Guid>()).ToArray();

	for(var i = 0; i < deletedFileIDCollection.Length; i++)
	{
		await mFiles.RemoveWithNotificationAsync(mFiles.TryGet(deletedFileIDCollection[i]), cancellationToken: this.CancellationToken);
	}

	// Перенос файлов из карточки диалога в основную карточку.
	var dCardFileContainer = (await Dialog.GetFileContainerAsync(cancellationToken: this.CancellationToken)).FileContainer;

	ValidationResult result;
	foreach (var dFile in dCardFileContainer.Files)
	{
		var fileIDContentSource = GetFileIDContentSource(dFile.ID);

		// Файл был перенесён из основной карточки?
		if (fileIDContentSource.HasValue)
		{
			var mFile = mFiles.TryGet(fileIDContentSource.Value);

			if (dFile.TryGetActualVersion().Number > 1)
			{
				if (!dFile.Content.HasData)
				{
					result = await dFile.EnsureContentDownloadedAsync(cancellationToken: this.CancellationToken);
					this.ValidationResult.Add(result);

					if (result.HasErrors)
					{
						return;
					}
				}

				result = await mFile.ReplaceAsync(await dFile.Content.GetAsync(this.CancellationToken), this.CancellationToken);
				this.ValidationResult.Add(result);

				if (result.HasErrors)
				{
					return;
				}
			}

			result = await mFile.RenameAsync(dFile.Name, this.CancellationToken);
			this.ValidationResult.Add(result);

			if(result.HasErrors)
			{
				return;
			}
		}
		else
		{
			if (!dFile.Content.HasData)
			{
				result = await dFile.EnsureContentDownloadedAsync(cancellationToken: this.CancellationToken);
				this.ValidationResult.Add(result);

				if (result.HasErrors)
				{
					return;
				}
			}

			result = (await mCardFileContainer
				.BuildFile(dFile.Name)
				.SetContent(dFile.Content)
				.SetVersionToken(
					(ft, ct) =>
					{
						var lastVersion = dFile.Versions.Last();

						ft.Created = lastVersion.Created;
						ft.CreatedByID = lastVersion.CreatedByID;
						ft.CreatedByName = lastVersion.CreatedByName;

						ft.Hash = lastVersion.Hash;

						return new ValueTask();
					})
				.SetCategory(mCardFileCategoryName)
				.AddWithNotificationAsync(cancellationToken: this.CancellationToken)).Result;
			this.ValidationResult.Add(result);

			if (result.HasErrors)
			{
				return;
			}
		}
	}
}